/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.armors;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.platform.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetSuitModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"jetsuit"), "main");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/models/armor/jetsuit.png");
    private final HumanoidModel<LivingEntity> parentModel;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart waist;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart leftShoe;
    private final ModelPart rightShoe;
    private final ModelPart antenna;
    private final ModelPart lamp;
    private final EquipmentSlot slot;

    public JetSuitModel(ModelPart root, EquipmentSlot slot, ItemStack stack, @Nullable HumanoidModel<LivingEntity> parentModel) {
        super(root, RenderType::entityTranslucent);
        this.parentModel = parentModel;
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftArm = root.getChild("left_arm");
        this.rightArm = root.getChild("right_arm");
        this.waist = root.getChild("waist");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
        this.leftShoe = root.getChild("left_shoe");
        this.rightShoe = root.getChild("right_shoe");
        this.antenna = this.head.getChild("antenna_r1");
        this.lamp = this.head.getChild("lamp_r1");
        this.slot = slot;
        this.setVisible();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 0), PartPose.ZERO);
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.75f)).texOffs(16, 34).addBox(4.7f, -5.8f, 1.2f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        head.addOrReplaceChild("lamp_r1", CubeListBuilder.create().texOffs(48, 48).addBox(-2.0f, -1.0f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.7f, (float)-0.5f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("antenna_r1", CubeListBuilder.create().texOffs(50, 16).addBox(0.0f, -2.0f, -1.0f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.2f, (float)-5.8f, (float)4.2f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(26, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.75f)).texOffs(0, 16).addBox(-4.0f, 1.0f, 2.0f, 8.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(26, 32).addBox(-3.0f, 2.0f, 2.0f, 6.0f, 9.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 34).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.35f)).texOffs(48, 32).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.75f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(48, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.75f)).texOffs(0, 34).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.35f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, 0.0f, -2.1f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 45).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 45).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_shoe", CubeListBuilder.create().texOffs(32, 45).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.75f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_shoe", CubeListBuilder.create().texOffs(32, 45).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.75f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        if (Platform.isNeoForge()) {
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            vertexConsumer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
        }
        this.parentModel.copyPropertiesTo((HumanoidModel)this);
        this.leftShoe.copyFrom(this.leftLeg);
        this.rightShoe.copyFrom(this.rightLeg);
        super.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    @NotNull
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    @NotNull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightShoe, (Object)this.leftShoe);
    }

    public void setAllVisible(boolean visible) {
        super.setAllVisible(visible);
        this.antenna.visible = visible;
        this.lamp.visible = visible;
        this.waist.visible = visible;
        this.head.visible = visible;
        this.body.visible = visible;
        this.leftArm.visible = visible;
        this.rightArm.visible = visible;
        this.leftLeg.visible = visible;
        this.rightLeg.visible = visible;
        this.leftShoe.visible = visible;
        this.rightShoe.visible = visible;
    }

    private void setVisible() {
        this.setAllVisible(false);
        switch (this.slot) {
            case HEAD: {
                this.head.visible = true;
                this.lamp.visible = true;
                this.antenna.visible = true;
                break;
            }
            case CHEST: {
                this.body.visible = true;
                this.rightArm.visible = true;
                this.leftArm.visible = true;
                break;
            }
            case LEGS: {
                this.rightLeg.visible = true;
                this.leftLeg.visible = true;
                break;
            }
            case FEET: {
                this.leftShoe.visible = true;
                this.rightShoe.visible = true;
            }
        }
    }
}

